/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskClassLoader;
import filenet.vw.apps.taskman.VWTaskManagerLoader;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskProperties;
import filenet.vw.apps.taskman.VWTaskThreadGroup;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.VWEventLogHandler;
import filenet.vw.base.util.SecureJSSEProps;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Appender;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWTaskApplication {
    private static Properties JSSE_PROPS = null;
    private static VWTaskClassLoader m_classLoader;
    private static boolean m_bLoggingInitialzed;
    private static final String m_className;
    private static Logger logger;
    private static boolean m_bIsARelaunchedPTM;
    private static boolean m_hasRelaunchedAnotherPTM;
    private static int m_bRelaunchedPTMExitValue;
    private static VWCommandLineArgs m_args;
    private static final String APPLICATION_PACKAGE = "filenet.vw.apps.taskman";

    private static void traceJSSE_PROPS() {
        if (logger == null) {
            return;
        }
        if (JSSE_PROPS != null && JSSE_PROPS.size() > 0) {
            StringBuilder b = new StringBuilder();
            Set<Object> keySet = JSSE_PROPS.keySet();
            for (Object key : keySet) {
                b.append(key).append("=").append(JSSE_PROPS.get(key)).append(",");
            }
            logger.info(m_className, "JSSEPROPS", b.toString());
        } else {
            logger.finest(m_className, "JSSEPROPS", "p8pejsse.properties file is not found.  No JSSE properties were set.");
        }
    }

    public static void main(String[] args) {
        final String[] theArgs = args;
        try {
            System.setProperty("java.util.prefs.PreferencesFactory", "filenet.vw.apps.taskman.VWTaskDisableSystemPrefsFactory");
            Runnable mainRunner = new Runnable(){

                public void run() {
                    try {
                        VWTaskApplication.run(theArgs);
                        if (m_hasRelaunchedAnotherPTM) {
                            System.exit(m_bRelaunchedPTMExitValue);
                        } else if (Boolean.getBoolean("TaskManager.AutoStart") || Boolean.getBoolean("TaskManager.AutoStop")) {
                            System.exit(0);
                        }
                    }
                    catch (Throwable ex) {
                        if (logger != null) {
                            StringWriter sw = new StringWriter();
                            ex.printStackTrace(new PrintWriter(sw));
                            logger.log(Level.SEVERE, m_className, "main", sw.toString());
                        } else {
                            ex.printStackTrace();
                        }
                        System.exit(1);
                    }
                }
            };
            Thread tmThread = new Thread(VWTaskThreadGroup.getInstance(), mainRunner);
            tmThread.setName(VWTaskApplication.class.getName());
            tmThread.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static VWCommandLineArgs getCommandLineArgs() {
        return m_args;
    }

    protected static void autoStart() throws Exception {
        VWTaskApplication.run(new String[]{"-autostart"});
    }

    protected static void autoStop() throws Exception {
        VWTaskApplication.run(new String[]{"-autostop"});
    }

    private static void run(String[] args) throws Exception {
        String strLocale;
        String method = "run";
        char[] paramBeginChars = new char[]{'-'};
        m_args = new VWCommandLineArgs(args, false, paramBeginChars);
        m_bIsARelaunchedPTM = m_args.isPresent("relaunched");
        boolean bDebugOn = m_args.isPresent("debug");
        System.setProperty("TaskManager.AutoStart", new Boolean(m_args.isPresent("autostart")).toString());
        System.setProperty("TaskManager.AutoStop", new Boolean(m_args.isPresent("autostop")).toString());
        boolean automode = Boolean.getBoolean("TaskManager.AutoStart") || Boolean.getBoolean("TaskManager.AutoStop");
        String tmPropertiesPath = System.getProperty("TaskManager.Properties");
        VWTaskProperties tmProperties = VWTaskProperties.getInstance(tmPropertiesPath);
        VWTaskApplication.initializeLogging(bDebugOn, tmProperties);
        VWTaskApplication.traceJSSE_PROPS();
        logger.fine(m_className, method, "Default Locale: " + Locale.getDefault());
        if (automode && m_bIsARelaunchedPTM && tmProperties.getProperty("TaskManager.ServiceName", null) != null && tmProperties.getBoolean("TaskManager.ServiceMode")) {
            System.setProperty("filenet.vw.base.logging.ServiceName", tmProperties.getProperty("TaskManager.ServiceName"));
            logger.addHandler((Appender)new VWEventLogHandler(VWTaskApplication.class.getName()));
        }
        if ((strLocale = tmProperties.getProperty("TaskManager.Locale", null)) != null) {
            logger.fine("Setting default locale: " + strLocale);
            try {
                Locale locale = null;
                String[] tokens = strLocale.split(",");
                if (tokens.length == 1) {
                    locale = new Locale(tokens[0]);
                } else if (tokens.length == 2) {
                    locale = new Locale(tokens[0], tokens[1]);
                } else if (tokens.length == 3) {
                    locale = new Locale(tokens[0], tokens[1], tokens[2]);
                }
                if (locale != null) {
                    Locale.setDefault(locale);
                } else {
                    logger.fine("Invalid locale specified: " + strLocale);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Unable to set locale: " + strLocale, e);
            }
        }
        if (!tmProperties.getBoolean("TaskManager.DisableJava2dWorkAround")) {
            System.setProperty("sun.java2d.noddraw", "true");
        }
        VWTaskProperties.initSystemProperties(tmProperties);
        if (!m_bIsARelaunchedPTM && !tmProperties.getBoolean("TaskManager.DisableRelaunch")) {
            logger.fine(m_className, method, "Initializing classpath for relaunch.");
            logger.fine(m_className, method, "Current system classpath: " + System.getProperty("java.class.path"));
            ArrayList<String> cpList = new ArrayList<String>(Arrays.asList(System.getProperty("java.class.path").split(File.pathSeparator)));
            String tmClasspath = tmProperties.getProperty("TaskManager.Classpath", null);
            if (tmClasspath != null) {
                ArrayList<String> tmCPList = new ArrayList<String>(Arrays.asList(tmClasspath.split(File.pathSeparator)));
                cpList.addAll(tmCPList);
            }
            if (tmProperties.getBoolean("TaskManager.ConsolidatedView") && !automode) {
                try {
                    logger.fine(m_className, method, "Performing consolidated view initialization.");
                    String xmlPath = VWTaskUtil.removeTrailingSlash(tmProperties.getProperty("TaskManager.P8TASKMAN_HOME")) + File.separator + "taskmaninstances.xml";
                    VWTaskXMLHandler xmlHandler = new VWTaskXMLHandler(xmlPath);
                    Node[] nodes = VWTaskXMLHandler.getNodesNamed(xmlHandler.getRootNode(), "Product");
                    if (nodes != null) {
                        for (int i = 0; i < nodes.length; ++i) {
                            Element ele = (Element)nodes[i];
                            String productName = ele.getAttribute("name");
                            logger.fine(m_className, method, "Loading product: " + productName);
                            String cp = VWTaskXMLHandler.getXMLString(VWTaskXMLHandler.getNodeNamed(ele, "classpath"));
                            logger.fine(m_className, method, productName + " classpath: " + cp);
                            ArrayList<String> productCPList = new ArrayList<String>(Arrays.asList(cp.split(File.pathSeparator)));
                            cpList.addAll(productCPList);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, m_className, method, "Exception initializing consolicated view classpath.", ex);
                }
            }
            StringBuffer classpath = new StringBuffer();
            StringBuffer frontClasspath = new StringBuffer();
            for (int i = 0; i < cpList.size(); ++i) {
                String item = (String)cpList.get(i);
                if (item.indexOf("pa.jar") != -1 || item.indexOf("ps.jar") != -1) {
                    logger.fine(m_className, method, "Found pa or ps.jar and moving it to front: " + item);
                    if (frontClasspath.length() > 0) {
                        frontClasspath.append(File.pathSeparator);
                    }
                    frontClasspath.append(item);
                    continue;
                }
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(item);
            }
            classpath.insert(0, File.pathSeparator);
            classpath.insert(0, frontClasspath.toString());
            logger.fine(m_className, method, "Updated classpath: " + classpath.toString());
            m_hasRelaunchedAnotherPTM = true;
            logger.fine(m_className, method, "Relaunching application to pickup new Java flags.");
            ArrayList<String> javaArgs = new ArrayList<String>();
            boolean foundMaxMem = false;
            try {
                String flagsStr = tmProperties.getProperty("TaskManager.VMFlags");
                if (flagsStr != null) {
                    String[] flags = tmProperties.getProperty("TaskManager.VMFlags").split(" ");
                    for (int i = 0; i < flags.length; ++i) {
                        String arg = flags[i];
                        if (arg.startsWith("-cp") || arg.startsWith("-classpath")) {
                            ++i;
                            continue;
                        }
                        if (arg.startsWith("-Xmx")) {
                            foundMaxMem = true;
                        }
                        javaArgs.add(arg);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, m_className, method, "Exception trying to construct java args from taskman.properties.", e);
            }
            if (System.getProperty("JPEVIRTUALSERVER") != null) {
                javaArgs.add("-DJPEVIRTUALSERVER=" + System.getProperty("JPEVIRTUALSERVER"));
            }
            if (System.getProperty("JPEDATA_DIR") != null) {
                javaArgs.add("-DJPEDATA_DIR=" + System.getProperty("JPEDATA_DIR"));
            }
            if (!foundMaxMem) {
                javaArgs.add("-Xmx256m");
            }
            javaArgs.add("-Djava.util.prefs.PreferencesFactory=filenet.vw.apps.taskman.VWTaskDisableSystemPrefsFactory");
            javaArgs.add("-DTaskManager.Properties=" + System.getProperty("TaskManager.Properties"));
            javaArgs.add("-cp");
            javaArgs.add(classpath.toString());
            StringBuffer cmd = new StringBuffer("filenet.vw.apps.taskman.VWTaskApplication -relaunched");
            Enumeration e = m_args.parameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                cmd.append(" -" + param);
                String value = m_args.getParameter(param);
                if (value.equals("")) continue;
                cmd.append(" " + value);
            }
            VWTaskProcessResult result = VWTaskProcessLauncher.launchJavaProcess(javaArgs, cmd.toString(), true, !OperatingSystem.isWindows() || automode || bDebugOn || tmProperties.getBoolean("TaskManager.WaitOnRelaunch"), true, false, null);
            m_bRelaunchedPTMExitValue = result != null ? result.exitValue() : 0;
            return;
        }
        new VWTaskManagerLoader();
    }

    protected static void initializeLogging(boolean commandLineDebugFlag, VWTaskProperties tmProperties) {
        if (!m_bLoggingInitialzed) {
            String logFile = null;
            if (tmProperties.getBoolean("TaskManager.ProcessService")) {
                String dataDir = System.getProperty("JPEDATA_DIR");
                logFile = dataDir + File.separator + "logs" + File.separator + "vwtaskman.log";
            } else {
                logFile = new File(System.getProperty("TaskManager.Properties")).getAbsoluteFile().getParent();
                if (!logFile.endsWith(File.separator)) {
                    logFile = logFile + File.separator;
                }
                logFile = logFile + "vwtaskman.log";
            }
            StringBuffer buffer = new StringBuffer(logFile);
            for (int index = 0; index < buffer.length(); ++index) {
                if (buffer.charAt(index) != '\\') continue;
                buffer.replace(index, index + 1, "/");
            }
            System.setProperty("PELogFile", buffer.toString());
            if (tmProperties.getBoolean("TaskManager.Debug") || commandLineDebugFlag) {
                System.setProperty("PELogLevel", "FINEST");
                VWDebug.init(System.out, VWLogger.INFORMATION);
                VWDebug.setLogFile(logFile, VWLogger.INFORMATION);
            } else {
                System.setProperty("PELogLevel", "INFO");
                VWDebug.init(System.out, VWLogger.ERROR);
                VWDebug.setLogFile(logFile, VWLogger.ERROR);
            }
            logger = Logger.getLogger(APPLICATION_PACKAGE);
            m_bLoggingInitialzed = true;
        }
    }

    public static String _get_FILE_DATE() {
        return "$Date:   05 May 2009 11:04:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.39  $";
    }

    static {
        try {
            JSSE_PROPS = SecureJSSEProps.SetJSSEProps();
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_classLoader = null;
        m_bLoggingInitialzed = false;
        m_className = VWTaskApplication.class.getName();
        logger = null;
        m_bIsARelaunchedPTM = false;
        m_hasRelaunchedAnotherPTM = false;
        m_bRelaunchedPTMExitValue = 0;
        m_args = null;
    }
}

